/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.accumulator;

import com.mrh0.createaddition.blocks.accumulator.AccumulatorTileEntity;
import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.NodeRotation;
import com.mrh0.createaddition.index.CATileEntities;
import com.mrh0.createaddition.util.IComparatorOverride;
import com.simibubi.create.content.contraptions.ITransformableBlock;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AccumulatorBlock
extends Block
implements IBE<AccumulatorTileEntity>,
IWrenchable,
ITransformableBlock {
    public static final VoxelShape ACCUMULATOR_SHAPE_MAIN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    public static final VoxelShape ACCUMULATOR_SHAPE_X = Shapes.m_83124_((VoxelShape)ACCUMULATOR_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)0.0, (double)6.0, (double)5.0, (double)16.0, (double)10.0), Block.m_49796_((double)11.0, (double)0.0, (double)6.0, (double)15.0, (double)16.0, (double)10.0)});
    public static final VoxelShape ACCUMULATOR_SHAPE_Z = Shapes.m_83124_((VoxelShape)ACCUMULATOR_SHAPE_MAIN, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)6.0, (double)0.0, (double)1.0, (double)10.0, (double)16.0, (double)5.0), Block.m_49796_((double)6.0, (double)0.0, (double)11.0, (double)10.0, (double)16.0, (double)15.0)});
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    public AccumulatorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(NodeRotation.ROTATION, (Comparable)((Object)NodeRotation.NONE)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worlIn, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = ((Direction)state.m_61143_((Property)FACING)).m_122434_();
        return axis == Direction.Axis.X ? ACCUMULATOR_SHAPE_X : ACCUMULATOR_SHAPE_Z;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, NodeRotation.ROTATION});
    }

    public BlockState m_5573_(BlockPlaceContext c) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(c.m_43723_().m_6144_() ? c.m_8125_().m_122428_() : c.m_8125_().m_122427_()));
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity entity, ItemStack stack) {
        BlockEntity te = world.m_7702_(pos);
        if (te != null && te instanceof AccumulatorTileEntity) {
            CompoundTag nbt;
            AccumulatorTileEntity ate = (AccumulatorTileEntity)te;
            if (stack.m_41782_() && (nbt = stack.m_41783_()).m_128441_("energy")) {
                ate.setEnergy(nbt.m_128451_("energy"));
            }
        }
        super.m_6402_(world, pos, state, entity, stack);
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(worldIn, pos, state, player);
        if (worldIn.m_5776_()) {
            return;
        }
        BlockEntity te = worldIn.m_7702_(pos);
        if (te == null) {
            return;
        }
        if (!(te instanceof IWireNode)) {
            return;
        }
        IWireNode cte = (IWireNode)te;
        cte.dropWires(worldIn, !player.m_7500_());
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext c) {
        BlockEntity te = c.m_43725_().m_7702_(c.m_8083_());
        if (te == null) {
            return super.onSneakWrenched(state, c);
        }
        if (!(te instanceof IWireNode)) {
            return super.onSneakWrenched(state, c);
        }
        IWireNode cte = (IWireNode)te;
        if (!c.m_43725_().m_5776_()) {
            cte.dropWires(c.m_43725_(), c.m_43723_(), !c.m_43723_().m_7500_());
        }
        return super.onSneakWrenched(state, c);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        return IComparatorOverride.getComparetorOverride(worldIn, pos);
    }

    public BlockState m_6843_(BlockState state, Rotation direction) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)direction.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState rotate(BlockState state, LevelAccessor world, BlockPos pos, Rotation direction) {
        return this.m_6843_(state, direction);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState transform(BlockState state, StructureTransform transform) {
        NodeRotation rotation = NodeRotation.get(transform.rotationAxis, transform.rotation);
        if (transform.mirror != null) {
            state = this.m_6943_(state, transform.mirror);
        }
        if (transform.rotationAxis == Direction.Axis.Y) {
            state = this.m_6843_(state, transform.rotation);
        }
        return (BlockState)state.m_61124_(NodeRotation.ROTATION, (Comparable)((Object)rotation));
    }

    public Class<AccumulatorTileEntity> getBlockEntityClass() {
        return AccumulatorTileEntity.class;
    }

    public BlockEntityType<? extends AccumulatorTileEntity> getBlockEntityType() {
        return (BlockEntityType)CATileEntities.ACCUMULATOR.get();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CATileEntities.ACCUMULATOR.create(pos, state);
    }
}

